//
// make-sta-codes.cpp
//
// Bill Seymour, 2023-01-2
//
// Copyright Bill Seymour 2023.
//
// Distributed under the Boost Software License, Version 1.0.
// (See accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)
//
// This program just reads a list of Amtrak station codes and station names
// from the standard input and writes to the standard output a bunch of
// array initializers for including in other C++ programs.
//
// The input file is probably already sorted alphabetically, but we'll
// sort it anyway just in case that changes in the future.  This is
// something that won't ever have to be done again unless Amtrak's
// station codes change.
//

#include <iostream>
#include <string>
#include <vector>
#include <algorithm>

using namespace std;

int main()
{
    vector<string> input;
    for (string s; getline(cin, s); )
    {
        input.push_back(s);
    }
    sort(input.begin(), input.end());

    cout << "//\n"
            "// MACHINE-GENERATED CODE.\n"
            "//\n"
            "// This is a cross-reference of Amtrak station codes to cities\n"
            "// to be #included in an array initializer.\n"
            "//\n"
            "// The data is from "
              "https://juckins.net/amtrak_status/archive/html/stations.php.\n"
            "//\n";

    typedef vector<string>::const_iterator iter;
    for (iter it = input.cbegin(), end = input.cend(); it != end; ++it)
    {
        // The input line is station-code[horizontal-tab]station-name.
        cout << "{\""
             << it->substr(0, 3)
             << "\",\""
             << it->substr(4)
             << "\"},\n";
    }
}

// End of make-sta-codes.cpp
